/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.Deflater;

class RfbProto {
    final String versionMsg = "RFB 003.003\n";
    static final int ConnFailed = 0;
    static final int NoAuth = 1;
    static final int VncAuth = 2;
    static final int VncAuthOK = 0;
    static final int VncAuthFailed = 1;
    static final int VncAuthTooMany = 2;
    static final int FramebufferUpdate = 0;
    static final int SetColourMapEntries = 1;
    static final int Bell = 2;
    static final int ServerCutText = 3;
    final int SetPixelFormat = 0;
    final int FixColourMapEntries = 1;
    final int SetEncodings = 2;
    final int FramebufferUpdateRequest = 3;
    final int KeyboardEvent = 4;
    final int PointerEvent = 5;
    final int ClientCutText = 6;
    static final int EncodingRaw = 0;
    static final int EncodingCopyRect = 1;
    static final int EncodingRRE = 2;
    static final int EncodingCoRRE = 4;
    static final int EncodingHextile = 5;
    static final int EncodingZlib = 6;
    static final int EncodingTight = 7;
    static final int EncodingCompressLevel0 = -256;
    static final int EncodingQualityLevel0 = -32;
    static final int EncodingXCursor = -240;
    static final int EncodingRichCursor = -239;
    static final int EncodingLastRect = -224;
    static final int EncodingNewFBSize = -223;
    final int HextileRaw = 1;
    final int HextileBackgroundSpecified = 2;
    final int HextileForegroundSpecified = 4;
    final int HextileAnySubrects = 8;
    final int HextileSubrectsColoured = 16;
    static final int TightExplicitFilter = 4;
    static final int TightFill = 8;
    static final int TightJpeg = 9;
    static final int TightMaxSubencoding = 9;
    static final int TightFilterCopy = 0;
    static final int TightFilterPalette = 1;
    static final int TightFilterGradient = 2;
    static final int TightMinToCompress = 12;
    String host;
    int port;
    Socket sock;
    DataInputStream is;
    OutputStream os;
    SessionRecorder rec;
    boolean inNormalProtocol = false;
    VncViewer viewer;
    boolean brokenKeyPressed = false;
    boolean wereZlibUpdates = false;
    boolean recordFromBeginning = true;
    boolean zlibWarningShown;
    boolean tightWarningShown;
    int numUpdatesInSession;
    int serverMajor;
    int serverMinor;
    String desktopName;
    int framebufferWidth;
    int framebufferHeight;
    int bitsPerPixel;
    int depth;
    boolean bigEndian;
    boolean trueColour;
    int redMax;
    int greenMax;
    int blueMax;
    int redShift;
    int greenShift;
    int blueShift;
    int updateNRects;
    int updateRectX;
    int updateRectY;
    int updateRectW;
    int updateRectH;
    int updateRectEncoding;
    int copyRectSrcX;
    int copyRectSrcY;
    byte[] eventBuf = new byte[72];
    int eventBufLen;
    static final int CTRL_MASK = 2;
    static final int SHIFT_MASK = 1;
    static final int META_MASK = 4;
    static final int ALT_MASK = 8;
    int pointerMask = 0;
    int oldModifiers = 0;

    int makeSessionIDRequest(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        System.err.println("UrlConnection.class: " + uRLConnection.getClass());
        uRLConnection.setDoInput(true);
        uRLConnection.setUseCaches(false);
        uRLConnection.connect();
        InputStream inputStream = uRLConnection.getInputStream();
        byte[] byArray = new byte[4];
        int n = inputStream.read(byArray);
        System.err.println("buffer: <<" + new String(byArray) + ">>");
        if (n != 4) {
            throw new IOException("Couldn't read session id.");
        }
        int n2 = 0 | byArray[0] << 0 & 0xFF | byArray[1] << 8 & 0xFF00 | byArray[2] << 16 & 0xFF0000 | byArray[3] << 24 & 0xFF000000;
        System.err.println("session-id: " + n2);
        return n2;
    }

    int getSessionID(URL uRL) throws IOException {
        Opener opener;
        class Opener
        extends Thread {
            URL url;
            int id;
            IOException error;
            int openState = 1;

            Opener(URL uRL) {
                this.url = uRL;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    int n = RfbProto.this.makeSessionIDRequest(this.url);
                    Opener opener = this;
                    synchronized (opener) {
                        this.id = n;
                        this.openState = 2;
                        this.notifyAll();
                    }
                }
                catch (IOException iOException) {
                    Opener opener = this;
                    synchronized (opener) {
                        this.error = iOException;
                        this.openState = 3;
                        this.notifyAll();
                    }
                }
            }
        }
        Opener opener2 = opener = new Opener(uRL);
        synchronized (opener2) {
            opener.start();
            long l = System.currentTimeMillis() + 10000L;
            do {
                try {
                    long l2 = l - System.currentTimeMillis();
                    System.out.println("waiting " + l2 + " msecs ...");
                    opener.wait(l2);
                    System.out.println("woke up ");
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (opener.openState == 1 && l - System.currentTimeMillis() > 0L);
            switch (opener.openState) {
                case 1: {
                    throw new IOException("timeout");
                }
                case 3: {
                    throw opener.error;
                }
                case 2: {
                    return opener.id;
                }
            }
            throw new Error("Bug");
        }
    }

    URL getHttpUrl(String string, int n, boolean bl) throws IOException {
        try {
            System.err.println("Trying tunnel-connection...");
            int n2 = this.getSessionID(new URL("http", string, n, "/get-session-id"));
            return new URL("http", string, n, "/vnc-session?id=" + n2);
        }
        catch (IOException iOException) {
            System.err.println("Tunnel-connection failed: " + iOException.getMessage() + "\n");
            if (bl) {
                System.err.println("Trying Apache ...");
                int n3 = this.getSessionID(new URL("http", string, 80, "/get-session-id-" + n));
                return new URL("http", string, 80, "/vnc-session-" + n + "?id=" + n3);
            }
            throw iOException;
        }
    }

    void initHttp(String string, int n, boolean bl) throws IOException {
        URL uRL = this.getHttpUrl(string, n, bl);
        this.os = new TunnelWriter(uRL).getOutputStream();
        this.is = new DataInputStream(new BufferedInputStream(new TunnelReader(uRL).getInputStream(), 16384));
    }

    void initTcp(String string, int n) throws IOException {
        this.sock = new Socket(string, n);
        this.is = new DataInputStream(new BufferedInputStream(this.sock.getInputStream(), 16384));
        this.os = this.sock.getOutputStream();
    }

    RfbProto(String string, int n, VncViewer vncViewer) throws IOException {
        this.viewer = vncViewer;
        this.host = string;
        this.port = n;
        this.initTcp(string, n);
    }

    RfbProto(String string, int n, int n2, boolean bl, VncViewer vncViewer) throws IOException {
        this.viewer = vncViewer;
        this.host = string;
        this.port = n;
        if (this.port == -1) {
            this.initHttp(string, n2, bl);
        } else {
            try {
                this.initTcp(string, n);
            }
            catch (Exception exception) {
                System.err.println("Socket-connection failed: " + exception.getMessage() + "\n" + "Trying HTTP tunnel...");
                this.initHttp(string, n2, bl);
            }
        }
    }

    void close() {
        try {
            if (this.sock != null) {
                this.sock.close();
            }
            if (this.rec != null) {
                this.rec.close();
                this.rec = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void readVersionMsg() throws Exception {
        byte[] byArray = new byte[12];
        this.is.readFully(byArray);
        if (byArray[0] != 82 || byArray[1] != 70 || byArray[2] != 66 || byArray[3] != 32 || byArray[4] < 48 || byArray[4] > 57 || byArray[5] < 48 || byArray[5] > 57 || byArray[6] < 48 || byArray[6] > 57 || byArray[7] != 46 || byArray[8] < 48 || byArray[8] > 57 || byArray[9] < 48 || byArray[9] > 57 || byArray[10] < 48 || byArray[10] > 57 || byArray[11] != 10) {
            throw new Exception("Host " + this.host + " port " + this.port + " is not an RFB server");
        }
        this.serverMajor = (byArray[4] - 48) * 100 + (byArray[5] - 48) * 10 + (byArray[6] - 48);
        this.serverMinor = (byArray[8] - 48) * 100 + (byArray[9] - 48) * 10 + (byArray[10] - 48);
    }

    void writeVersionMsg() throws IOException {
        System.err.print("writing versionmsg::: RFB 003.003\n");
        this.os.write("RFB 003.003\n".getBytes());
        System.err.println("");
    }

    int readAuthScheme() throws Exception {
        int n = this.is.readInt();
        switch (n) {
            case 0: {
                int n2 = this.is.readInt();
                byte[] byArray = new byte[n2];
                this.is.readFully(byArray);
                throw new Exception(new String(byArray));
            }
            case 1: 
            case 2: {
                return n;
            }
        }
        throw new Exception("Unknown authentication scheme from RFB server: " + n);
    }

    void writeClientInit() throws IOException {
        if (this.viewer.options.shareDesktop) {
            this.os.write(1);
        } else {
            this.os.write(0);
        }
        this.viewer.options.disableShareDesktop();
    }

    void readServerInit() throws IOException {
        this.framebufferWidth = this.is.readUnsignedShort();
        this.framebufferHeight = this.is.readUnsignedShort();
        this.bitsPerPixel = this.is.readUnsignedByte();
        this.depth = this.is.readUnsignedByte();
        this.bigEndian = this.is.readUnsignedByte() != 0;
        this.trueColour = this.is.readUnsignedByte() != 0;
        this.redMax = this.is.readUnsignedShort();
        this.greenMax = this.is.readUnsignedShort();
        this.blueMax = this.is.readUnsignedShort();
        this.redShift = this.is.readUnsignedByte();
        this.greenShift = this.is.readUnsignedByte();
        this.blueShift = this.is.readUnsignedByte();
        byte[] byArray = new byte[3];
        this.is.readFully(byArray);
        int n = this.is.readInt();
        byte[] byArray2 = new byte[n];
        this.is.readFully(byArray2);
        this.desktopName = new String(byArray2);
        this.inNormalProtocol = true;
    }

    void startSession(String string) throws IOException {
        this.rec = new SessionRecorder(string);
        this.rec.writeHeader();
        this.rec.write("RFB 003.003\n".getBytes());
        this.rec.writeIntBE(1);
        this.rec.writeShortBE(this.framebufferWidth);
        this.rec.writeShortBE(this.framebufferHeight);
        byte[] byArray = new byte[]{32, 24, 0, 1, 0, -1, 0, -1, 0, -1, 16, 8, 0, 0, 0, 0};
        this.rec.write(byArray);
        this.rec.writeIntBE(this.desktopName.length());
        this.rec.write(this.desktopName.getBytes());
        this.numUpdatesInSession = 0;
        if (this.wereZlibUpdates) {
            this.recordFromBeginning = false;
        }
        this.zlibWarningShown = false;
        this.tightWarningShown = false;
    }

    void closeSession() throws IOException {
        if (this.rec != null) {
            this.rec.close();
            this.rec = null;
        }
    }

    void setFramebufferSize(int n, int n2) {
        this.framebufferWidth = n;
        this.framebufferHeight = n2;
    }

    int readServerMessageType() throws IOException {
        int n = this.is.readUnsignedByte();
        if (this.rec != null && n == 2) {
            this.rec.writeByte(n);
            if (this.numUpdatesInSession > 0) {
                this.rec.flush();
            }
        }
        return n;
    }

    void readFramebufferUpdate() throws IOException {
        this.is.readByte();
        this.updateNRects = this.is.readUnsignedShort();
        if (this.rec != null) {
            this.rec.writeByte(0);
            this.rec.writeByte(0);
            this.rec.writeShortBE(this.updateNRects);
        }
        ++this.numUpdatesInSession;
    }

    void readFramebufferUpdateRectHdr() throws Exception {
        this.updateRectX = this.is.readUnsignedShort();
        this.updateRectY = this.is.readUnsignedShort();
        this.updateRectW = this.is.readUnsignedShort();
        this.updateRectH = this.is.readUnsignedShort();
        this.updateRectEncoding = this.is.readInt();
        if (this.updateRectEncoding == 6 || this.updateRectEncoding == 7) {
            this.wereZlibUpdates = true;
        }
        if (this.rec != null) {
            if (this.numUpdatesInSession > 1) {
                this.rec.flush();
            }
            this.rec.writeShortBE(this.updateRectX);
            this.rec.writeShortBE(this.updateRectY);
            this.rec.writeShortBE(this.updateRectW);
            this.rec.writeShortBE(this.updateRectH);
            if (this.updateRectEncoding == 6 && !this.recordFromBeginning) {
                if (!this.zlibWarningShown) {
                    System.out.println("Warning: Raw encoding will be used instead of Zlib in recorded session.");
                    this.zlibWarningShown = true;
                }
                this.rec.writeIntBE(0);
            } else {
                this.rec.writeIntBE(this.updateRectEncoding);
                if (this.updateRectEncoding == 7 && !this.recordFromBeginning && !this.tightWarningShown) {
                    System.out.println("Warning: Re-compressing Tight-encoded updates for session recording.");
                    this.tightWarningShown = true;
                }
            }
        }
        if (this.updateRectEncoding == -224 || this.updateRectEncoding == -223) {
            return;
        }
        if (this.updateRectX + this.updateRectW > this.framebufferWidth || this.updateRectY + this.updateRectH > this.framebufferHeight) {
            throw new Exception("Framebuffer update rectangle too large: " + this.updateRectW + "x" + this.updateRectH + " at (" + this.updateRectX + "," + this.updateRectY + ")");
        }
    }

    void readCopyRect() throws IOException {
        this.copyRectSrcX = this.is.readUnsignedShort();
        this.copyRectSrcY = this.is.readUnsignedShort();
        if (this.rec != null) {
            this.rec.writeShortBE(this.copyRectSrcX);
            this.rec.writeShortBE(this.copyRectSrcY);
        }
    }

    String readServerCutText() throws IOException {
        byte[] byArray = new byte[3];
        this.is.readFully(byArray);
        int n = this.is.readInt();
        byte[] byArray2 = new byte[n];
        this.is.readFully(byArray2);
        return new String(byArray2);
    }

    int readCompactLen() throws IOException {
        int[] nArray = new int[3];
        nArray[0] = this.is.readUnsignedByte();
        int n = 1;
        int n2 = nArray[0] & 0x7F;
        if ((nArray[0] & 0x80) != 0) {
            nArray[1] = this.is.readUnsignedByte();
            ++n;
            n2 |= (nArray[1] & 0x7F) << 7;
            if ((nArray[1] & 0x80) != 0) {
                nArray[2] = this.is.readUnsignedByte();
                ++n;
                n2 |= (nArray[2] & 0xFF) << 14;
            }
        }
        if (this.rec != null && this.recordFromBeginning) {
            for (int i = 0; i < n; ++i) {
                this.rec.writeByte(nArray[i]);
            }
        }
        return n2;
    }

    void writeFramebufferUpdateRequest(int n, int n2, int n3, int n4, boolean bl) throws IOException {
        byte[] byArray = new byte[]{3, (byte)(bl ? 1 : 0), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 & 0xFF), (byte)(n3 >> 8 & 0xFF), (byte)(n3 & 0xFF), (byte)(n4 >> 8 & 0xFF), (byte)(n4 & 0xFF)};
        this.os.write(byArray);
    }

    void writeSetPixelFormat(int n, int n2, boolean bl, boolean bl2, int n3, int n4, int n5, int n6, int n7, int n8) throws IOException {
        byte[] byArray = new byte[20];
        byArray[0] = 0;
        byArray[4] = (byte)n;
        byArray[5] = (byte)n2;
        byArray[6] = (byte)(bl ? 1 : 0);
        byArray[7] = (byte)(bl2 ? 1 : 0);
        byArray[8] = (byte)(n3 >> 8 & 0xFF);
        byArray[9] = (byte)(n3 & 0xFF);
        byArray[10] = (byte)(n4 >> 8 & 0xFF);
        byArray[11] = (byte)(n4 & 0xFF);
        byArray[12] = (byte)(n5 >> 8 & 0xFF);
        byArray[13] = (byte)(n5 & 0xFF);
        byArray[14] = (byte)n6;
        byArray[15] = (byte)n7;
        byArray[16] = (byte)n8;
        this.os.write(byArray);
    }

    void writeFixColourMapEntries(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3) throws IOException {
        byte[] byArray = new byte[6 + n2 * 6];
        byArray[0] = 1;
        byArray[2] = (byte)(n >> 8 & 0xFF);
        byArray[3] = (byte)(n & 0xFF);
        byArray[4] = (byte)(n2 >> 8 & 0xFF);
        byArray[5] = (byte)(n2 & 0xFF);
        for (int i = 0; i < n2; ++i) {
            byArray[6 + i * 6] = (byte)(nArray[i] >> 8 & 0xFF);
            byArray[6 + i * 6 + 1] = (byte)(nArray[i] & 0xFF);
            byArray[6 + i * 6 + 2] = (byte)(nArray2[i] >> 8 & 0xFF);
            byArray[6 + i * 6 + 3] = (byte)(nArray2[i] & 0xFF);
            byArray[6 + i * 6 + 4] = (byte)(nArray3[i] >> 8 & 0xFF);
            byArray[6 + i * 6 + 5] = (byte)(nArray3[i] & 0xFF);
        }
        this.os.write(byArray);
    }

    void writeSetEncodings(int[] nArray, int n) throws IOException {
        byte[] byArray = new byte[4 + 4 * n];
        byArray[0] = 2;
        byArray[2] = (byte)(n >> 8 & 0xFF);
        byArray[3] = (byte)(n & 0xFF);
        for (int i = 0; i < n; ++i) {
            byArray[4 + 4 * i] = (byte)(nArray[i] >> 24 & 0xFF);
            byArray[5 + 4 * i] = (byte)(nArray[i] >> 16 & 0xFF);
            byArray[6 + 4 * i] = (byte)(nArray[i] >> 8 & 0xFF);
            byArray[7 + 4 * i] = (byte)(nArray[i] & 0xFF);
        }
        this.os.write(byArray);
    }

    void writeClientCutText(String string) throws IOException {
        byte[] byArray = new byte[8 + string.length()];
        byArray[0] = 6;
        byArray[4] = (byte)(string.length() >> 24 & 0xFF);
        byArray[5] = (byte)(string.length() >> 16 & 0xFF);
        byArray[6] = (byte)(string.length() >> 8 & 0xFF);
        byArray[7] = (byte)(string.length() & 0xFF);
        System.arraycopy(string.getBytes(), 0, byArray, 8, string.length());
        this.os.write(byArray);
    }

    void writePointerEvent(MouseEvent mouseEvent) throws IOException {
        int n = mouseEvent.getModifiers();
        int n2 = 2;
        int n3 = 4;
        if (this.viewer.options.reverseMouseButtons2And3) {
            n2 = 4;
            n3 = 2;
        }
        if (mouseEvent.getID() == 501) {
            if ((n & 8) != 0) {
                this.pointerMask = n2;
                n &= 0xFFFFFFF7;
            } else if ((n & 4) != 0) {
                this.pointerMask = n3;
                n &= 0xFFFFFFFB;
            } else {
                this.pointerMask = 1;
            }
        } else if (mouseEvent.getID() == 502) {
            this.pointerMask = 0;
            if ((n & 8) != 0) {
                n &= 0xFFFFFFF7;
            } else if ((n & 4) != 0) {
                n &= 0xFFFFFFFB;
            }
        }
        this.eventBufLen = 0;
        this.writeModifierKeyEvents(n);
        int n4 = mouseEvent.getX();
        int n5 = mouseEvent.getY();
        if (n4 < 0) {
            n4 = 0;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        this.eventBuf[this.eventBufLen++] = 5;
        this.eventBuf[this.eventBufLen++] = (byte)this.pointerMask;
        this.eventBuf[this.eventBufLen++] = (byte)(n4 >> 8 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n4 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n5 >> 8 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n5 & 0xFF);
        if (this.pointerMask == 0) {
            this.writeModifierKeyEvents(0);
        }
        this.os.write(this.eventBuf, 0, this.eventBufLen);
    }

    void writeKeyEvent(KeyEvent keyEvent) throws IOException {
        int n;
        boolean bl;
        block44: {
            int n2;
            block43: {
                n2 = keyEvent.getKeyChar();
                if (n2 == 0) {
                    n2 = 65535;
                }
                if (n2 == 65535 && ((bl = keyEvent.getKeyCode()) || bl || bl || bl)) {
                    return;
                }
                boolean bl2 = bl = keyEvent.getID() == 401;
                if (!keyEvent.isActionKey()) break block43;
                switch (keyEvent.getKeyCode()) {
                    case 36: {
                        n = 65360;
                        break block44;
                    }
                    case 37: {
                        n = 65361;
                        break block44;
                    }
                    case 38: {
                        n = 65362;
                        break block44;
                    }
                    case 39: {
                        n = 65363;
                        break block44;
                    }
                    case 40: {
                        n = 65364;
                        break block44;
                    }
                    case 33: {
                        n = 65365;
                        break block44;
                    }
                    case 34: {
                        n = 65366;
                        break block44;
                    }
                    case 35: {
                        n = 65367;
                        break block44;
                    }
                    case 155: {
                        n = 65379;
                        break block44;
                    }
                    case 112: {
                        n = 65470;
                        break block44;
                    }
                    case 113: {
                        n = 65471;
                        break block44;
                    }
                    case 114: {
                        n = 65472;
                        break block44;
                    }
                    case 115: {
                        n = 65473;
                        break block44;
                    }
                    case 116: {
                        n = 65474;
                        break block44;
                    }
                    case 117: {
                        n = 65475;
                        break block44;
                    }
                    case 118: {
                        n = 65476;
                        break block44;
                    }
                    case 119: {
                        n = 65477;
                        break block44;
                    }
                    case 120: {
                        n = 65478;
                        break block44;
                    }
                    case 121: {
                        n = 65479;
                        break block44;
                    }
                    case 122: {
                        n = 65480;
                        break block44;
                    }
                    case 123: {
                        n = 65481;
                        break block44;
                    }
                    default: {
                        return;
                    }
                }
            }
            n = n2;
            if (n < 32) {
                if (keyEvent.isControlDown()) {
                    n += 96;
                } else {
                    switch (n) {
                        case 8: {
                            n = 65288;
                            break;
                        }
                        case 9: {
                            n = 65289;
                            break;
                        }
                        case 10: {
                            n = 65293;
                            break;
                        }
                        case 27: {
                            n = 65307;
                        }
                    }
                }
            } else if (n == 127) {
                n = 65535;
            } else if (n > 255 && (n < 65280 || n > 65535)) {
                return;
            }
        }
        if (n == 229 || n == 197 || n == 228 || n == 196 || n == 246 || n == 214 || n == 167 || n == 189 || n == 163) {
            if (bl) {
                this.brokenKeyPressed = true;
            }
            if (!bl && !this.brokenKeyPressed) {
                this.eventBufLen = 0;
                this.writeModifierKeyEvents(keyEvent.getModifiers());
                this.writeKeyEvent(n, true);
                this.os.write(this.eventBuf, 0, this.eventBufLen);
            }
            if (!bl) {
                this.brokenKeyPressed = false;
            }
        }
        this.eventBufLen = 0;
        this.writeModifierKeyEvents(keyEvent.getModifiers());
        this.writeKeyEvent(n, bl);
        if (!bl) {
            this.writeModifierKeyEvents(0);
        }
        this.os.write(this.eventBuf, 0, this.eventBufLen);
    }

    void writeKeyEvent(int n, boolean bl) {
        this.eventBuf[this.eventBufLen++] = 4;
        this.eventBuf[this.eventBufLen++] = (byte)(bl ? 1 : 0);
        this.eventBuf[this.eventBufLen++] = 0;
        this.eventBuf[this.eventBufLen++] = 0;
        this.eventBuf[this.eventBufLen++] = (byte)(n >> 24 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n >> 16 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n >> 8 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n & 0xFF);
    }

    void writeModifierKeyEvents(int n) {
        if ((n & 2) != (this.oldModifiers & 2)) {
            this.writeKeyEvent(65507, (n & 2) != 0);
        }
        if ((n & 1) != (this.oldModifiers & 1)) {
            this.writeKeyEvent(65505, (n & 1) != 0);
        }
        if ((n & 4) != (this.oldModifiers & 4)) {
            this.writeKeyEvent(65511, (n & 4) != 0);
        }
        if ((n & 8) != (this.oldModifiers & 8)) {
            this.writeKeyEvent(65513, (n & 8) != 0);
        }
        this.oldModifiers = n;
    }

    void recordCompressedData(byte[] byArray, int n, int n2) throws IOException {
        Deflater deflater = new Deflater();
        deflater.setInput(byArray, n, n2);
        int n3 = n2 + n2 / 100 + 12;
        byte[] byArray2 = new byte[n3];
        deflater.finish();
        int n4 = deflater.deflate(byArray2);
        this.recordCompactLen(n4);
        this.rec.write(byArray2, 0, n4);
    }

    void recordCompressedData(byte[] byArray) throws IOException {
        this.recordCompressedData(byArray, 0, byArray.length);
    }

    void recordCompactLen(int n) throws IOException {
        byte[] byArray = new byte[3];
        int n2 = 0;
        byArray[n2++] = (byte)(n & 0x7F);
        if (n > 127) {
            int n3 = n2 - 1;
            byArray[n3] = (byte)(byArray[n3] | 0x80);
            byArray[n2++] = (byte)(n >> 7 & 0x7F);
            if (n > 16383) {
                int n4 = n2 - 1;
                byArray[n4] = (byte)(byArray[n4] | 0x80);
                byArray[n2++] = (byte)(n >> 14 & 0xFF);
            }
        }
        this.rec.write(byArray, 0, n2);
    }
}

