/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

class TunnelReader
extends InputStream {
    URL url;
    InputStream tunnel;

    TunnelReader(URL uRL) throws IOException {
        this.url = uRL;
        this.tunnel = this.connect(uRL);
    }

    InputStream getInputStream() throws IOException {
        return this;
    }

    private static final void trace(String string) {
    }

    InputStream connect(URL uRL) throws IOException {
        TunnelReader.trace("connect");
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setDoOutput(false);
        uRLConnection.setDoInput(true);
        uRLConnection.setUseCaches(false);
        uRLConnection.connect();
        return uRLConnection.getInputStream();
    }

    void reconnect() throws IOException {
        this.tunnel = this.connect(this.url);
    }

    @Override
    public synchronized int read() throws IOException {
        TunnelReader.trace("read");
        int n;
        while ((n = this.tunnel.read()) < 0) {
            this.reconnect();
        }
        return n;
    }

    @Override
    public synchronized int read(byte[] byArray) throws IOException {
        TunnelReader.trace("read");
        int n;
        while ((n = this.tunnel.read(byArray)) < 0) {
            this.reconnect();
        }
        return n;
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        TunnelReader.trace("read");
        int n3;
        while ((n3 = this.tunnel.read(byArray, n, n2)) < 0) {
            this.reconnect();
        }
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        TunnelReader.trace("skip ...");
        return this.tunnel.skip(l);
    }

    @Override
    public synchronized int available() throws IOException {
        TunnelReader.trace("available");
        int n = this.tunnel.available();
        return n;
    }

    @Override
    public void close() throws IOException {
        TunnelReader.trace("Reader close ...");
        this.tunnel.close();
        this.tunnel = null;
        this.url = null;
    }

    @Override
    public void mark(int n) {
        TunnelReader.trace("Reader mark ...");
        this.tunnel.mark(n);
    }

    @Override
    public void reset() throws IOException {
        TunnelReader.trace("Reader reset ...");
        this.tunnel.reset();
    }

    @Override
    public boolean markSupported() {
        TunnelReader.trace("markSupported ...");
        return this.tunnel.markSupported();
    }
}

