/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;

public class VncViewer
extends Applet
implements Runnable,
WindowListener {
    boolean inAnApplet = true;
    boolean inSeparateFrame = false;
    String[] mainArgs;
    RfbProto rfb;
    Thread rfbThread;
    Frame vncFrame;
    Container vncContainer;
    ScrollPane desktopScrollPane;
    GridBagLayout gridbag;
    ButtonPanel buttonPanel;
    AuthPanel authenticator;
    VncCanvas vc;
    OptionsFrame options;
    ClipboardFrame clipboard;
    RecordingFrame rec;
    Object recordingSync;
    String sessionFileName;
    boolean recordingActive;
    boolean recordingStatusChanged;
    String cursorUpdatesDef;
    String eightBitColorsDef;
    String host;
    int port;
    int tunnelPort;
    boolean useApache = false;
    String passwordParam;
    String encPasswordParam;
    boolean showControls;
    boolean showOfflineDesktop;
    int deferScreenUpdates;
    int deferCursorUpdates;
    int deferUpdateRequests;
    boolean disconnectRequested = false;

    public static void main(String[] stringArray) {
        VncViewer vncViewer = new VncViewer();
        vncViewer.mainArgs = stringArray;
        vncViewer.inAnApplet = false;
        vncViewer.inSeparateFrame = true;
        vncViewer.init();
        vncViewer.start();
    }

    @Override
    public void init() {
        this.readParameters();
        if (this.inSeparateFrame) {
            this.vncFrame = new Frame("TightVNC");
            if (!this.inAnApplet) {
                this.vncFrame.add("Center", this);
            }
            this.vncContainer = this.vncFrame;
        } else {
            this.vncContainer = this;
        }
        this.recordingSync = new Object();
        this.options = new OptionsFrame(this);
        this.clipboard = new ClipboardFrame(this);
        this.authenticator = new AuthPanel();
        if (RecordingFrame.checkSecurity()) {
            this.rec = new RecordingFrame(this);
        }
        this.sessionFileName = null;
        this.recordingActive = false;
        this.recordingStatusChanged = false;
        this.cursorUpdatesDef = null;
        this.eightBitColorsDef = null;
        if (this.inSeparateFrame) {
            this.vncFrame.addWindowListener(this);
        }
        this.rfbThread = new Thread(this);
        this.rfbThread.start();
    }

    @Override
    public void update(Graphics graphics) {
    }

    @Override
    public void run() {
        this.gridbag = new GridBagLayout();
        this.vncContainer.setLayout(this.gridbag);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        if (this.showControls) {
            this.buttonPanel = new ButtonPanel(this);
            this.gridbag.setConstraints(this.buttonPanel, gridBagConstraints);
            this.vncContainer.add(this.buttonPanel);
        }
        try {
            this.connectAndAuthenticate();
            this.doProtocolInitialisation();
            this.vc = new VncCanvas(this);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            if (this.inSeparateFrame) {
                Panel panel = new Panel();
                panel.setLayout(new FlowLayout(0, 0, 0));
                panel.add(this.vc);
                this.desktopScrollPane = new ScrollPane(0);
                gridBagConstraints.fill = 1;
                this.gridbag.setConstraints(this.desktopScrollPane, gridBagConstraints);
                this.desktopScrollPane.add(panel);
                this.vncFrame.add(this.desktopScrollPane);
                this.vncFrame.setTitle(this.rfb.desktopName);
                this.vncFrame.pack();
                this.vc.resizeDesktopFrame();
            } else {
                this.gridbag.setConstraints(this.vc, gridBagConstraints);
                this.add(this.vc);
                this.validate();
            }
            if (this.showControls) {
                this.buttonPanel.enableButtons();
            }
            this.moveFocusToDesktop();
            this.vc.processNormalProtocol();
        }
        catch (NoRouteToHostException noRouteToHostException) {
            noRouteToHostException.printStackTrace();
            this.fatalError("Network error: no route to server: " + this.host);
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            this.fatalError("Network error: server name unknown: " + this.host);
        }
        catch (ConnectException connectException) {
            connectException.printStackTrace();
            this.fatalError("Network error: could not connect to server: " + this.host + ":" + this.port);
        }
        catch (EOFException eOFException) {
            eOFException.printStackTrace();
            if (this.showOfflineDesktop) {
                System.out.println("Network error: remote side closed connection");
                if (this.vc != null) {
                    this.vc.enableInput(false);
                }
                if (this.inSeparateFrame) {
                    this.vncFrame.setTitle(this.rfb.desktopName + " [disconnected]");
                }
                if (this.rfb != null) {
                    this.rfb.close();
                    this.rfb = null;
                }
                if (this.showControls && this.buttonPanel != null) {
                    this.buttonPanel.disableButtonsOnDisconnect();
                    if (this.inSeparateFrame) {
                        this.vncFrame.pack();
                    } else {
                        this.validate();
                    }
                }
            } else {
                this.fatalError("Network error: remote side closed connection");
            }
        }
        catch (IOException iOException) {
            String string = iOException.getMessage();
            iOException.printStackTrace();
            if (string != null && string.length() != 0) {
                this.fatalError("Network Error: " + string);
            } else {
                this.fatalError(iOException.toString());
            }
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            exception.printStackTrace();
            if (string != null && string.length() != 0) {
                this.fatalError("Error: " + string);
            }
            this.fatalError(exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectAndAuthenticate() throws Exception {
        Object object;
        if (this.encPasswordParam != null) {
            Object object2;
            object = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
            int n = this.encPasswordParam.length() / 2;
            if (n > 8) {
                n = 8;
            }
            for (int i = 0; i < n; ++i) {
                object2 = this.encPasswordParam.substring(i * 2, i * 2 + 2);
                Integer n2 = new Integer(Integer.parseInt((String)object2, 16));
                object[i] = n2.byteValue();
            }
            byte[] byArray = new byte[]{23, 82, 107, 6, 35, 78, 88, 7};
            object2 = new DesCipher(byArray);
            ((DesCipher)object2).decrypt((byte[])object, 0, (byte[])object, 0);
            this.passwordParam = new String((byte[])object);
        }
        if (this.passwordParam != null) {
            if (this.inSeparateFrame) {
                this.vncFrame.pack();
                this.vncFrame.show();
            } else {
                this.validate();
            }
            if (!this.tryAuthenticate(this.passwordParam)) {
                throw new Exception("VNC authentication failed");
            }
            return;
        }
        object = new GridBagConstraints();
        ((GridBagConstraints)object).gridwidth = 0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 1.0;
        ((GridBagConstraints)object).ipadx = 100;
        ((GridBagConstraints)object).ipady = 50;
        this.gridbag.setConstraints(this.authenticator, (GridBagConstraints)object);
        this.vncContainer.add(this.authenticator);
        if (this.inSeparateFrame) {
            this.vncFrame.pack();
            this.vncFrame.show();
        } else {
            this.validate();
            this.authenticator.moveFocusToPasswordField();
        }
        while (true) {
            AuthPanel authPanel = this.authenticator;
            synchronized (authPanel) {
                try {
                    this.authenticator.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.tryAuthenticate(this.authenticator.password.getText())) break;
            this.authenticator.retry();
        }
        this.vncContainer.remove(this.authenticator);
    }

    boolean tryAuthenticate(String string) throws Exception {
        System.err.println("PORT=" + this.port + "; TUNNELPORT=" + this.tunnelPort + "; USE_APACHE=" + this.useApache);
        this.rfb = this.tunnelPort == -1 ? new RfbProto(this.host, this.port, this) : new RfbProto(this.host, this.port, this.tunnelPort, this.useApache, this);
        this.rfb.readVersionMsg();
        System.out.println("RFB server supports protocol version " + this.rfb.serverMajor + "." + this.rfb.serverMinor);
        this.rfb.writeVersionMsg();
        int n = this.rfb.readAuthScheme();
        block0 : switch (n) {
            case 1: {
                System.out.println("No authentication needed");
                return true;
            }
            case 2: {
                int n2;
                byte[] byArray = new byte[16];
                this.rfb.is.readFully(byArray);
                if (string.length() > 8) {
                    string = string.substring(0, 8);
                }
                if ((n2 = string.indexOf(0)) != -1) {
                    string = string.substring(0, n2);
                }
                byte[] byArray2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
                System.arraycopy(string.getBytes(), 0, byArray2, 0, string.length());
                DesCipher desCipher = new DesCipher(byArray2);
                desCipher.encrypt(byArray, 0, byArray, 0);
                desCipher.encrypt(byArray, 8, byArray, 8);
                this.rfb.os.write(byArray);
                int n3 = this.rfb.is.readInt();
                switch (n3) {
                    case 0: {
                        System.out.println("VNC authentication succeeded");
                        return true;
                    }
                    case 1: {
                        System.out.println("VNC authentication failed");
                        break block0;
                    }
                    case 2: {
                        throw new Exception("VNC authentication failed - too many tries");
                    }
                }
                throw new Exception("Unknown VNC authentication result " + n3);
            }
            default: {
                throw new Exception("Unknown VNC authentication scheme " + n);
            }
        }
        return false;
    }

    void doProtocolInitialisation() throws IOException {
        this.rfb.writeClientInit();
        this.rfb.readServerInit();
        System.out.println("Desktop name is " + this.rfb.desktopName);
        System.out.println("Desktop size is " + this.rfb.framebufferWidth + " x " + this.rfb.framebufferHeight);
        this.setEncodings();
    }

    void setEncodings() {
        try {
            if (this.rfb != null && this.rfb.inNormalProtocol) {
                this.rfb.writeSetEncodings(this.options.encodings, this.options.nEncodings);
                if (this.vc != null) {
                    this.vc.softCursorFree();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void setCutText(String string) {
        try {
            if (this.rfb != null && this.rfb.inNormalProtocol) {
                this.rfb.writeClientCutText(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRecordingStatus(String string) {
        Object object = this.recordingSync;
        synchronized (object) {
            this.sessionFileName = string;
            this.recordingStatusChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkRecordingStatus() throws IOException {
        Object object = this.recordingSync;
        synchronized (object) {
            if (this.recordingStatusChanged) {
                this.recordingStatusChanged = false;
                if (this.sessionFileName != null) {
                    this.startRecording();
                    return true;
                }
                this.stopRecording();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startRecording() throws IOException {
        Object object = this.recordingSync;
        synchronized (object) {
            if (!this.recordingActive) {
                this.cursorUpdatesDef = this.options.choices[this.options.cursorUpdatesIndex].getSelectedItem();
                this.eightBitColorsDef = this.options.choices[this.options.eightBitColorsIndex].getSelectedItem();
                this.options.choices[this.options.cursorUpdatesIndex].select("Disable");
                this.options.choices[this.options.cursorUpdatesIndex].setEnabled(false);
                this.options.setEncodings();
                this.options.choices[this.options.eightBitColorsIndex].select("No");
                this.options.choices[this.options.eightBitColorsIndex].setEnabled(false);
                this.options.setColorFormat();
            } else {
                this.rfb.closeSession();
            }
            System.out.println("Recording the session in " + this.sessionFileName);
            this.rfb.startSession(this.sessionFileName);
            this.recordingActive = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopRecording() throws IOException {
        Object object = this.recordingSync;
        synchronized (object) {
            if (this.recordingActive) {
                this.options.choices[this.options.cursorUpdatesIndex].select(this.cursorUpdatesDef);
                this.options.choices[this.options.cursorUpdatesIndex].setEnabled(true);
                this.options.setEncodings();
                this.options.choices[this.options.eightBitColorsIndex].select(this.eightBitColorsDef);
                this.options.choices[this.options.eightBitColorsIndex].setEnabled(true);
                this.options.setColorFormat();
                this.rfb.closeSession();
                System.out.println("Session recording stopped.");
            }
            this.sessionFileName = null;
            this.recordingActive = false;
        }
    }

    public void readParameters() {
        this.host = this.readParameter("HOST", !this.inAnApplet);
        if (this.host == null) {
            this.host = this.getCodeBase().getHost();
            if (this.host.equals("")) {
                this.fatalError("HOST parameter not specified");
            }
        }
        String string = this.readParameter("PORT", true);
        this.port = Integer.parseInt(string);
        string = this.readParameter("TUNNELPORT", true);
        this.tunnelPort = string != null ? Integer.parseInt(string) : -1;
        string = this.readParameter("USE_APACHE", false);
        this.useApache = string != null ? string.equalsIgnoreCase("Yes") : false;
        if (this.inAnApplet && (string = this.readParameter("Open New Window", false)) != null && string.equalsIgnoreCase("Yes")) {
            this.inSeparateFrame = true;
        }
        this.encPasswordParam = this.readParameter("ENCPASSWORD", false);
        if (this.encPasswordParam == null) {
            this.passwordParam = this.readParameter("PASSWORD", false);
        }
        this.showControls = true;
        string = this.readParameter("Show Controls", false);
        if (string != null && string.equalsIgnoreCase("No")) {
            this.showControls = false;
        }
        this.showOfflineDesktop = false;
        string = this.readParameter("Show Offline Desktop", false);
        if (string != null && string.equalsIgnoreCase("Yes")) {
            this.showOfflineDesktop = true;
        }
        this.deferScreenUpdates = this.readIntParameter("Defer screen updates", 20);
        this.deferCursorUpdates = this.readIntParameter("Defer cursor updates", 10);
        this.deferUpdateRequests = this.readIntParameter("Defer update requests", 50);
    }

    public String readParameter(String string, boolean bl) {
        if (this.inAnApplet) {
            String string2 = this.getParameter(string);
            if (string2 == null && bl) {
                this.fatalError(string + " parameter not specified");
            }
            return string2;
        }
        for (int i = 0; i < this.mainArgs.length; i += 2) {
            if (!this.mainArgs[i].equalsIgnoreCase(string)) continue;
            try {
                return this.mainArgs[i + 1];
            }
            catch (Exception exception) {
                if (bl) {
                    this.fatalError(string + " parameter not specified");
                }
                return null;
            }
        }
        if (bl) {
            this.fatalError(string + " parameter not specified");
        }
        return null;
    }

    int readIntParameter(String string, int n) {
        String string2 = this.readParameter(string, false);
        int n2 = n;
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    void moveFocusToDesktop() {
        if (this.vncContainer != null) {
            if (this.vc != null && this.vncContainer.isAncestorOf(this.vc)) {
                this.vc.requestFocus();
            } else if (this.vncContainer.isAncestorOf(this.authenticator)) {
                this.authenticator.moveFocusToPasswordField();
            }
        }
    }

    public synchronized void disconnect() {
        this.disconnectRequested = true;
        if (this.rfb != null) {
            this.rfb.close();
            this.rfb = null;
        }
        System.out.println("Disconnect");
        this.options.dispose();
        this.clipboard.dispose();
        if (this.rec != null) {
            this.rec.dispose();
        }
        if (this.inAnApplet) {
            this.vncContainer.removeAll();
            Label label = new Label("Disconnected");
            label.setFont(new Font("Helvetica", 0, 12));
            this.vncContainer.setLayout(new FlowLayout(0, 30, 30));
            this.vncContainer.add(label);
            if (this.inSeparateFrame) {
                this.vncFrame.pack();
            } else {
                this.validate();
            }
            this.rfbThread.stop();
        } else {
            System.exit(0);
        }
    }

    public synchronized void fatalError(String string) {
        if (this.rfb != null) {
            this.rfb.close();
            this.rfb = null;
        }
        System.out.println(string);
        if (this.disconnectRequested) {
            this.disconnectRequested = false;
            return;
        }
        if (this.inAnApplet) {
            this.vncContainer.removeAll();
            Label label = new Label(string);
            label.setFont(new Font("Helvetica", 0, 12));
            this.vncContainer.setLayout(new FlowLayout(0, 30, 30));
            this.vncContainer.add(label);
            if (this.inSeparateFrame) {
                this.vncFrame.pack();
            } else {
                this.validate();
            }
            Thread.currentThread().stop();
        } else {
            System.exit(1);
        }
    }

    @Override
    public void destroy() {
        this.vncContainer.removeAll();
        this.options.dispose();
        this.clipboard.dispose();
        if (this.rec != null) {
            this.rec.dispose();
        }
        if (this.rfb != null) {
            this.rfb.close();
        }
        if (this.inSeparateFrame) {
            this.vncFrame.dispose();
        }
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (this.rfb != null) {
            this.disconnect();
        }
        this.vncFrame.dispose();
        if (!this.inAnApplet) {
            System.exit(0);
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        if (this.vncFrame.isAncestorOf(this.authenticator)) {
            this.authenticator.moveFocusToPasswordField();
        }
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }
}

